<?php
/**
 * Template part for displaying creative posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Provem
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'posts-list__item creative-item invert-hover' ); ?>>

	<?php if ( has_post_thumbnail() ) : ?>
		<div class="creative-item__thumbnail" <?php Provem_post_overlay_thumbnail( 'Provem-thumb-m' ); ?>></div>
	<?php endif; ?>

	<header class="entry-header">
		<?php
			Provem_posted_in();
			Provem_posted_on( array(
				'prefix' => __( 'Posted', 'Provem' )
			) );
		?>
		<h4 class="entry-title"><?php 
			Provem_sticky_label();
			the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' );
		?></h4>
	</header><!-- .entry-header -->

	<?php Provem_post_excerpt(); ?>

	<footer class="entry-footer">
		<div class="entry-meta">
			<div>
				<?php
					Provem_posted_by();
					Provem_post_comments( array(
						'prefix' => '<i class="fa fa-comment" aria-hidden="true"></i>'
					) );
					Provem_post_tags( array(
						'prefix' => __( 'Tags:', 'Provem' )
					) );
				?>
			</div>
			<?php
				Provem_post_link();
			?>
		</div>
		<?php Provem_edit_link(); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->
