<?php
/**
 * Template part for displaying creative posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Provem
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'posts-list__item creative-item' ); ?>>

	<?php
		if ( has_post_thumbnail() ) {
			global $wp_query;

			if ( $wp_query->current_post % 3 == 0 ) {
				?><div class="creative-item__thumbnail" <?php Provem_post_overlay_thumbnail( 'Provem-thumb-l' ); ?>></div><?php
			} else {
				Provem_post_thumbnail( 'Provem-thumb-m-2' );
			}
		}
	?>

	<div class="creative-item__content">

		<header class="entry-header">
			<div class="entry-meta"><?php
				Provem_posted_by();
				Provem_posted_in( array(
					'prefix' => __( 'In', 'Provem' ),
				) );
				Provem_posted_on( array(
					'prefix' => __( 'Posted', 'Provem' )
				) );
			?></div>
			<h3 class="entry-title"><?php 
				Provem_sticky_label();
				the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' );
			?></h3>
		</header><!-- .entry-header -->

		<?php Provem_post_excerpt(); ?>

		<footer class="entry-footer">
			<div class="entry-meta"><?php
				Provem_post_tags( array(
					'prefix' => __( 'Tags:', 'Provem' )
				) );
				?><div><?php
					Provem_post_link();
					Provem_post_comments( array(
						'prefix' => '<i class="fa fa-comment" aria-hidden="true"></i>',
						'class'  => 'comments-button'
					) );
				?></div>
			</div>
			<?php Provem_edit_link(); ?>
		</footer><!-- .entry-footer -->

	</div>

</article><!-- #post-<?php the_ID(); ?> -->
