<?php
/**
 * Template part for displaying default posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Provem
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('posts-list__item default-item'); ?>>

	<?php Provem_post_thumbnail( 'Provem-thumb-l' ); ?>

	<div class="default-item__content">

		<header class="entry-header">
			<h3 class="entry-title"><?php 
				Provem_sticky_label();
				the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' );
			?></h3>
			<div class="entry-meta">
				<?php
					Provem_posted_by();
					Provem_posted_in( array(
						'prefix' => __( 'In', 'Provem' ),
					) );
					Provem_posted_on( array(
						'prefix' => __( 'Posted', 'Provem' )
					) );
				?>
			</div><!-- .entry-meta -->
		</header><!-- .entry-header -->

		<?php Provem_post_excerpt(); ?>

		<footer class="entry-footer">
			<div class="entry-meta">
				<?php
					Provem_post_tags( array(
						'prefix' => __( 'Tags:', 'Provem' )
					) );
				?>
				<div><?php
					Provem_post_comments( array(
						'prefix' => '<i class="fa fa-comment" aria-hidden="true"></i>',
						'class'  => 'comments-button'
					) );
					Provem_post_link();
				?></div>
			</div>
			<?php Provem_edit_link(); ?>
		</footer><!-- .entry-footer -->

	</div>

</article><!-- #post-<?php the_ID(); ?> -->
