<?php
/**
 * Template part for displaying default posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Provem
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('posts-list__item default-item invert-item'); ?>>

	<?php if ( has_post_thumbnail() ) : ?>
		<div class="default-item__thumbnail" <?php Provem_post_overlay_thumbnail( 'Provem-thumb-l' ); ?>></div>
	<?php endif; ?>

	<div class="container">

		<header class="entry-header">
			<div class="entry-meta"><?php
				Provem_posted_by();
				Provem_posted_in( array(
					'prefix' => __( 'In', 'Provem' ),
				) );
				Provem_posted_on( array(
					'prefix' => __( 'Posted', 'Provem' )
				) );
				Provem_post_tags( array(
					'prefix' => __( 'Tags:', 'Provem' )
				) );
				Provem_post_comments( array(
					'postfix' => __( 'Comment(s)', 'Provem' )
				) );
			?></div><!-- .entry-meta -->
			<h3 class="entry-title"><?php 
				Provem_sticky_label();
				the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' );
			?></h3>
		</header><!-- .entry-header -->

		<?php Provem_post_excerpt(); ?>

		<footer class="entry-footer">
			<div class="entry-meta">
				<?php
					Provem_post_link();
				?>
			</div>
			<?php Provem_edit_link(); ?>
		</footer><!-- .entry-footer -->
	
	</div>

</article><!-- #post-<?php the_ID(); ?> -->
