<?php
/**
 * Template part for displaying default posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Provem
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'posts-list__item grid-item' ); ?>>
	<?php Provem_post_thumbnail( 'Provem-thumb-m-2' ); ?>
	<header class="entry-header">
		<div class="entry-meta">
			<?php
			Provem_posted_by();
			Provem_posted_in( array(
				'prefix' => __( 'In', 'Provem' ),
				'delimiter' => ', '
			) ); 
			Provem_posted_on( array(
				'prefix' => __( 'Posted', 'Provem' ),
			) ); 
			?>
		</div><!-- .entry-meta -->
		<h4 class="entry-title"><?php 
			Provem_sticky_label();
			the_title( '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a>' );
		?></h4>
	</header><!-- .entry-header -->

	<?php Provem_post_excerpt(); ?>

	<footer class="entry-footer">
		<div class="entry-meta">
			<?php
			Provem_post_tags();

			$post_more_btn_enabled = strlen( Provem_theme()->customizer->get_value( 'blog_read_more_text' ) ) > 0 ? true : false;
			$post_comments_enabled = Provem_theme()->customizer->get_value( 'blog_post_comments' );

			if( $post_more_btn_enabled || $post_comments_enabled ) {
				?><div class="space-between-content"><?php
				Provem_post_link();
				Provem_post_comments();
				?></div><?php
			}
			?>
		</div>
		<?php Provem_edit_link(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
