<?php
/**
 * Template part for breadcrumbs.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Provem
 */

$breadcrumbs_visibillity = Provem_theme()->customizer->get_value( 'breadcrumbs_visibillity' );

/**
 * [$breadcrumbs_visibillity description]
 * @var [type]
 */
$breadcrumbs_visibillity = apply_filters( 'Provem-theme/breadcrumbs/breadcrumbs-visibillity', $breadcrumbs_visibillity );

if ( ! $breadcrumbs_visibillity ) {
	return;
}

$breadcrumbs_front_visibillity = Provem_theme()->customizer->get_value( 'breadcrumbs_front_visibillity' );

if ( !$breadcrumbs_front_visibillity && is_front_page() ) {
	return;
}

do_action( 'Provem-theme/breadcrumbs/breadcrumbs-before-render' );

?><div <?php echo Provem_get_container_classes( 'site-breadcrumbs' ); ?>>
	<div <?php Provem_breadcrumbs_class(); ?>>
		<?php do_action( 'Provem-theme/breadcrumbs/before' ); ?>
		<?php do_action( 'cx_breadcrumbs/render' ); ?>
		<?php do_action( 'Provem-theme/breadcrumbs/after' ); ?>
	</div>
</div><?php

do_action( 'Provem-theme/breadcrumbs/breadcrumbs-after-render' );
